
;;;Bosse-engineering                                                                                       
;;;Dipl.-Ing. Jrn Bosse                                                                                   
;;;Am Klei 5                                                                                               
;;;38458 Velpke                                                                                            
;;;Tel. 05364 / 989 677                                                                                    
;;;mobil. 0176 / 282 323 51                                                                                
;;;bosse@bosse-engineering.com                                                                             
;;;                                                                                                        
;;;--------------------------------------------------------------------------------------------------------
;;;Funktion c: LAF - LayerFarben: es knnen Listen mit Layerfarben gespeichert werden. Die Listenfarben	   
;;;knnen auf die Layer in der aktuellen Zeichnung angebracht werden.					   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;;;globale Variablen:										   	   
;;;- JB_LAF$DCL$_[x]_po (Positionen der Dialogfenster)							   
;;;- JB_LAF_$DCL$_File (temporre DCL-Datei)								   
;;;                                                                              Jrn Bosse, 19.08.24	   
;;;--------------------------------------------------------------------------------------------------------

;;;aufrufenden Funktionen
(defun c:LAF ( / )
  (JB_LAF)
  )

;;;Intro
(defun JB_LAF:Intro (str / )
  (princ "\nerstellt durch Bosse-engineering - www.bosse-engineering.com\n")
  (princ "\n----------------------LAF(1.0), 19.08.24----------------------")
  (princ str)
  (princ "\n--------------------------------------------------------------")
  )




;;;Variablenliste
(defun JB_LAF:v_liste ( / )
  '(
     ( "DboxSettings" . (
                         ( "Dbox1" .
                            (
                             ("JB_1_r1-r2" . 1);;;0 = Farbe 1 = Layername
                             ("JB_1_t1" . "*");;;NameFilter
                             ("JB_1_to1" . "0");;;alle auswhlen
                             ("JB_1_l4" . nil);;;Liste mit Farben
                             
                             )
                          )
                         )
      ))
  )


;;;Pfad fr SIC-Datei in Windows-User
(defun JB_LAF:pfad_ini ( / )
  (strcat (JBf_String:Userpfad:WinUser
                           "LispData\\acad\\"     ;;;Hier ndern, wenn anderer Pfad gewnscht, z.B. MeineTools\\Sicherungen\\ => Der LAufwerksbuchstabe c:\\ wird automatisch gegen das Windows-Benutzerverzeichnis 
                           )"LAF_sic.lsp")  ;;;getauscht, z.B. c:\\User\\[WindowsUsername]\\LispData\\acad\\
  )

;;;Hauptfunktion
(defun JB_LAF ( / PFAD_INI V_LISTE)
  (vl-load-com)

  (setq pfad_ini (JB_LAF:pfad_ini))

  ;;;ab AutoCAD 2014, setzen von vertrauenswrdigen Pfaden fr Sicherungsdateien
  (if (JBf_AcadSystem:TrustedPaths?)
    (JBf_AcadSystem:TrustedPaths:Add (strcat(car(fnsplitl pfad_ini))"...")))

    (if (not(setq v_liste (if (findfile pfad_ini)
                          (load pfad_ini)nil)))
    (JBf_SIC:sichern
      (setq v_liste (JB_LAF:v_liste))pfad_ini nil))
  
  (vla-startundomark (vla-get-activedocument(vlax-get-acad-object)))
  (JBf_init
    '(("CMDECHO" 0)
      ("DIMZIN" 3)
      ))
  
  
  (JB_LAF:Intro "\nLAF: Layer-Farben: speichern und wiederherstellen.")

  

  (if (not
        (or (and JB_LAF_$DCL$_File(findfile JB_LAF_$DCL$_File))
            (setq JB_LAF_$DCL$_File (JB_LAF:dcl:Write))))
    (progn
      (alert "Die DCL-Datei konnte nicht geschrieben werden.")
      (exit)))
  (JB_LAF:Dbox1 v_liste pfad_ini)
     
   
  (princ "\nEnde.")
  (JBf_Reinit)
  (vla-endundomark (vla-get-activedocument(vlax-get-acad-object))) 
  (princ)
  )

 

(defun  JB_LAF:v_liste:DboxSettings:get (key v_liste / )
  (cdr(assoc key(cdr (assoc "DboxSettings" v_liste))))
)


(defun JB_LAF:v_liste:DboxSettings:put (key liste v_liste / DboxList) 
  (setq DboxList (cdr (assoc "DboxSettings" v_liste)))
  (setq DBoxList (JBf_list:subst:gc DBoxList liste key))
  (setq v_liste (JBf_list:subst:gc v_liste DBoxList "DboxSettings"))
  v_liste
  )

;;;aktuelle LayerFarbliste zurckgeben
(defun JB_LAF:Layer:Read ( / GCLIST OBJLIST)
  (vlax-for ITEM (vla-get-Layers(vla-get-activeDocument (vlax-get-acad-object)))
    (setq objList (entget(vlax-vla-object->ename ITEM)))
    (setq gcList (list (assoc 62 objList)
                       (cons 420(cdr(assoc 420 objList)))
                       (cons 430 (cdr(assoc 430 objList)))))
    (setq LayerList&DBox1 (cons(list (vla-get-name ITEM)(JBf_TrueColor:GetString gcList)gcList)LayerList&DBox1))
    )
  )

;;;LayerListe sortieren
(defun JB_LAF:Dbox1:Sort ( / )
  (setq l1&Dbox1
         (cond 
               ((= (cdr(assoc "JB_1_r1-r2" Settings&Dbox1)) 0);;;Farbe
                (vl-sort l1&Dbox1 '(lambda(e1 e2)(< (cadr e1)(cadr e2)))))
               ((= (cdr(assoc "JB_1_r1-r2" Settings&Dbox1)) 1);;;Name
                (vl-sort l1&Dbox1 '(lambda(e1 e2)(< (car e1)(car e2)))))
               )
        )
  )

;;;LayerList nach Namen gefilter
(defun JB_LAF:Dbox1:LayerFilterList ( / )
  (Setq l1&Dbox1
         (vl-remove-if '(lambda(X)
                          (not(wcmatch(strcase(car X))(strcase(cdr(assoc "JB_1_t1" Settings&Dbox1))))))
           LayerList&DBox1)
        )
  )


;;;ListenInitialisierung
(defun JB_LAF:Dbox1:Lists:Ini ( / )
  
  (setq l4&Dbox1 (mapcar 'car (cdr(assoc "JB_1_l4" Settings&Dbox1))))

  (if l1&Dbox1
    (progn
      (JB_LAF:Dbox1:action:b2:l1_sel)
      (if (and(= (cdr(assoc "JB_1_to1" Settings&dbox1))"0")(not l1_sel&Dbox1))(setq l1_sel&Dbox1 '(0)))
      )
    (setq l1_sel&Dbox1 nil)
    )

  (if l4&Dbox1
    (if (not l4_sel&Dbox1)
      (setq l4_sel&Dbox1 0))
    (setq l4_sel&Dbox1 nil)
    )
  )



;;;l1_auswahl bestimmen und max. Grenze von 256 Eintrgen bercksichtigen
(defun JB_LAF:DBox1:Lists:l1_sel ( / N)
  (if (= (cdr(assoc "JB_1_to1" Settings&Dbox1))"1");;;wenn alle
    (if (<=(length l1&DBox1)256)
         (progn
           (setq n -1)
           (setq l1_sel&Dbox1(mapcar '(lambda(X)(setq n (+ n 1)))l1&DBox1))
           )
         (progn
           (setq l1_sel&Dbox1 nil)
           (alert (strcat "Option \"alle auswhlen\":\n"
                    "Es sind mehr als 256 Layer in der Liste vorhanden, diese werden aus AutoCAD-technischen Grnden nicht mit der Farbe blau als selektiert dargestellt, sind aber trotzdem in der Auswahl enthalten."))
           )
         )
    )
  )
        
  

 
;;;DBox 1
(defun JB_LAF:Dbox1 (v_liste pfad_ini / LayerList&DBox1 L1&DBOX1 L1_SEL&DBOX1 L4&DBOX1 L4_SEL&DBOX1 LAYERFILTERLIST&BOX1 SETTINGS&DBOX1 DCLID OK)

  (setq Settings&Dbox1 (JB_LAF:v_liste:DboxSettings:get "Dbox1" v_liste))
  (JB_LAF:Layer:Read)
  (JB_LAF:Dbox1:LayerFilterList)
  (JB_LAF:Dbox1:Sort)
  (JB_LAF:Dbox1:Lists:Ini)
  
  (while (not (member ok '(99)))
    (setq DclId (JBf_Dcl:Load_dialog JB_LAF_$DCL$_File "JB_LAF_1" JB_LAF$DCL$_1_po))
    (JB_LAF:Dbox1:set)
    (JB_LAF:Dbox1:mode)
    (mapcar '(lambda (A) (action_tile A (strcat "(JB_LAF:Dbox1:action \"" A "\")")))
            '("JB_1_b1" "JB_1_b2" "JB_1_b3" "JB_1_b4" "JB_1_b5"
              "JB_1_l1" "JB_1_l4"
              "JB_1_r1" "JB_1_r2"
              "JB_1_to1"
              "cancel"
             )
    )
    (setq ok (start_dialog))
    (unload_dialog DclId)

    (setq v_liste (JB_LAF:v_liste:DboxSettings:put "Dbox1" Settings&dbox1 v_liste))
    (JBf_SIC:sichern v_liste pfad_ini nil)
    
    )
  
  )

;;;Farbe zuweisen
(defun JB_LAF:Dbox1:action:b2:ColorAdd (Sub color / GCLIST LAYERLIST SUB VLA-LAYER)
  (setq LayerList (entget (tblobjname "LAYER" (car Sub))))
  (setq LayerList (JBf_list:subst:gc LayerList (cdr(assoc 62 color))62))
  (setq LayerList (vl-remove-if '(lambda(X)(member(car X)'(420 430)))LayerList))
  (setq LayerList(append LayerList (vl-remove-if '(lambda(X)(not(cdr X)))(list (assoc 420 color)(assoc 430 color)))))
  (entmod LayerList)
  (setq gcList (list (assoc 62 LayerList)
                     (cons 420(cdr(assoc 420 LayerList)))
                     (cons 430 (cdr(assoc 430 LayerList)))))
  (setq sub (list (car Sub)(JBf_TrueColor:GetString gcList)gcList))
  (setq LayerList&DBox1 (subst sub (assoc (car sub)LayerList&DBox1)LayerList&DBox1))
  (JB_LAF:Dbox1:LayerFilterList)
  
  )

;;;Farbe zuweisen
(defun JB_LAF:Dbox1:action:b2 ( / COLOR GCLIST LAYERLIST N SUB)
  (if (= (cdr(assoc "JB_1_to1" Settings&dbox1))"0")
    (setq gcList (caddr(nth (car l1_sel&Dbox1)l1&DBox1)))
    (setq gcList (caddr(car l1&DBox1)))
    )
  (if (setq color(acad_truecolordlg (cond ((cdr(assoc 430 gcList))
                                           (assoc 430 gcList))
                                          ((cdr(assoc 420 gcList))
                                           (assoc 420 gcList))
                                          ('T (assoc 62 gcList)))
                   nil))
    (progn

      (if(= (cdr(assoc "JB_1_to1" Settings&dbox1))"0")
        (mapcar '(lambda(n)
                   (setq Sub (nth n l1&DBox1))
                   (JB_LAF:Dbox1:action:b2:ColorAdd Sub color)
                   )
          l1_sel&DBox1)

        (mapcar '(lambda(Sub)
                   (JB_LAF:Dbox1:action:b2:ColorAdd Sub color)
                   )
          l1&DBox1)
        )
    (vla-Regen (vla-get-ActiveDocument (vlax-get-acad-object)) acActiveViewport)
    
    (JB_LAF:Dbox1:set)))
  )


;;;ACtion l4 - Name nderbn
(defun JB_LAF:Dbox1:action:l4 ( / NAME)
  (if (and(setq name (JB_LAF:Dbox2
                   (nth l4_sel&Dbox1 l4&Dbox1)
                    "Farblistenname"
                   nil
                   ))
          (or (not(member name (vl-remove-if '(lambda(X)(= X (nth l4_sel&Dbox1 l4&Dbox1)))l4&Dbox1)))
              (alert "Der Name ist bereits vorhanden.")
              )
          )
    (progn
      
      (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1
                             (vl-sort(append (vl-remove-if '(lambda(X)(=(car X)(nth l4_sel&Dbox1 l4&Dbox1)))(cdr(assoc "JB_1_l4" Settings&dbox1)))
                                       (list (list name (cadr(assoc(nth l4_sel&Dbox1 l4&Dbox1)(cdr(assoc "JB_1_l4" Settings&dbox1)))))))
                               '(lambda(e1 e2)(< (car e1)(car e2))))"JB_1_l4"))
      (setq l4&DBox1 (mapcar 'car (cdr(assoc "JB_1_l4" Settings&Dbox1))))
      (setq l4_sel&Dbox1 (- (length l4&DBox1)(length(member name l4&DBox1))))
      (JB_LAF:Dbox1:set)
      (JB_LAF:Dbox1:mode)
      )
    )
  )
      
    

;;;Action b3 - FarbListe speichern
(defun JB_LAF:Dbox1:action:b3 ( / N NAME SAVELIST X)
  (if (setq name (JB_LAF:Dbox2
                   (if l4&Dbox1
                     (nth l4_sel&Dbox1 l4&Dbox1)
                     "<Farblistenname>")
                    "Farblistenname"
                   (list '(member wert&Dbox2 l4&Dbox1)
                         "Der Farblistenname existiert bereits, berschreiben?")
                   )
            )
    (progn
      (if(= (cdr(assoc "JB_1_to1" Settings&dbox1))"1")
        (setq SaveList l1&DBox1)
        (progn
          (setq n -1)
          (setq SaveList (vl-remove-if 'not
                           (mapcar '(lambda(X)
                                      (setq n (+ n 1))
                                      (if (member n l1_sel&DBox1)
                                        X))l1&DBox1))))
        )


      (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1
                             (vl-sort(append (vl-remove-if '(lambda(X)(=(car X)name))(cdr(assoc "JB_1_l4" Settings&dbox1)))
                                       (list (list name SaveList)))'(lambda(e1 e2)(< (car e1)(car e2))))"JB_1_l4"))
      (setq l4&DBox1 (mapcar 'car (cdr(assoc "JB_1_l4" Settings&Dbox1))))
      (setq l4_sel&Dbox1 (- (length l4&DBox1)(length(member name l4&DBox1))))
      (JB_LAF:Dbox1:set)
      (JB_LAF:Dbox1:mode)
      )
    )
  )


;;;Action b4 - Farbliste lschen
(defun JB_LAF:Dbox1:action:b4 ( / X)
  (setq Settings&Dbox1 (JBf_list:subst:gc Settings&Dbox1
                         (vl-remove-if 'not
                           (mapcar '(lambda(X)
                                      (if (/=(car X)(nth l4_sel&Dbox1 l4&DBox1))
                                        X)
                                      )
                             (cdr(assoc "JB_1_l4" Settings&Dbox1))))
                         "JB_1_l4"))
  (if(setq l4&Dbox1 (mapcar 'car (cdr(assoc "JB_1_l4" Settings&Dbox1))))
    (setq l4_sel&Dbox1
           (if (> l4_sel&Dbox1 0)
             (- l4_sel&Dbox1 1)
             0)
          )
    (setq l4_sel&Dbox1 nil)
    )
  (JB_LAF:Dbox1:set)
  (JB_LAF:Dbox1:mode)
  )


;;;Action b5 - Farbliste Wiederherstellen
(defun JB_LAF:Dbox1:action:b5 ( / N SUB X)
  (setq n 0)
  (mapcar '(lambda(X)
             (if(setq Sub(assoc(car X)LayerList&DBox1))
               (progn
                 (setq n (+ n 1))
                 (JB_LAF:Dbox1:action:b2:ColorAdd Sub (caddr X)))
               )
             )
    (cadr(assoc(nth l4_sel&Dbox1 l4&Dbox1)(cdr(assoc "JB_1_l4" Settings&Dbox1)))))

  (if (> n 0)
    (progn
      (vla-Regen (vla-get-ActiveDocument (vlax-get-acad-object)) acActiveViewport)
      (alert (strcat "Es wurden die Farben von " (itoa n) " Layern(n) wiederhergestellt."))
      )
    )
  )

;;;ACtion - Nach Filternderung die Auswahl bestimmen
(defun JB_LAF:Dbox1:action:b2:l1_sel ( / N)
  (if (= (cdr(assoc "JB_1_to1" Settings&dbox1))"1")
    (if (<=(length l1&DBox1)256)
      (progn
        (setq n -1)
        (setq l1_sel&Dbox1(mapcar '(lambda(X)(setq n (+ n 1)))l1&DBox1))
        )
      (progn
        (setq l1_sel&Dbox1 nil)
        (alert "Es sind mehr als 256 Layer in der Liste vorhanden, diese werden aus AutoCAD-technischen Grnden nicht mit der Farbe blau als selektiert dargestellt, sind aber trotzdem in der Auswahl enthalten.")
        )
      )
    )
  )
 

;;;Action (Variable global in Aufrufender Funktion)
(defun JB_LAF:Dbox1:action (key / WERT)
  (cond
    ((= key "JB_1_b1");;;NameFilter
     (if (setq wert (JB_LAF:Dbox2 (cdr(assoc "JB_1_t1" Settings&dbox1)) "Layernamefilter"nil))
       (progn
         (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 wert "JB_1_t1"))
         (JB_LAF:Dbox1:LayerFilterList)
         (JB_LAF:Dbox1:Sort)
         (JB_LAF:Dbox1:Lists:Ini)
         (JB_LAF:Dbox1:action:b2:l1_sel)
         (JB_LAF:Dbox1:set)
         (JB_LAF:Dbox1:mode)
         
         )
       )
     )
     
    ((= key "JB_1_b2");;;Farbe ndern
     (JB_LAF:Dbox1:action:b2)     
     )
    ((= key "JB_1_b3");;;Farbliste speichern
     (JB_LAF:Dbox1:action:b3)     
     )
    ((= key "JB_1_b4");;;Farbliste lschen
     (JB_LAF:Dbox1:action:b4)     
     )
    ((= key "JB_1_b5");;;Farbliste anwenden
     (JB_LAF:Dbox1:action:b5)     
     )
    ((= key "JB_1_r1");;;Sortieren nach Farbe
     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 0 "JB_1_r1-r2"))
     (JB_LAF:Dbox1:Sort)
     (JB_LAF:Dbox1:set))
    ((= key "JB_1_r2");;;Sortieren nach Layername
     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 1 "JB_1_r1-r2"))
     (JB_LAF:Dbox1:Sort)
     (JB_LAF:Dbox1:set))
    ((= key "JB_1_l1");;;Listenauswahl 1
     (setq l1_sel&Dbox1 (mapcar 'atoi(JBf_String:Delimiter->List $value " ")))
     (if (>=(length l1_sel&Dbox1)256)
       (progn
         (set_tile "JB_1_l1" "")
         (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 "1" "JB_1_to1"))
         (set_tile "JB_1_to1" "1")
         (alert "Wenn mehr als 256 Zeilen ausgewhlt sind wird automatisch die Option alle aktiviert (weil es im AutoCAD-DCL technisch nicht mglich ist, mehr Zeilen zu selektieren.")
         )
       )
     (JB_LAF:Dbox1:mode)
     
     )
    ((= key "JB_1_l4");;;Listenauswahl 4
     (setq l4_sel&Dbox1 (atoi $value))
     (if (= $reason 4)
       (JB_LAF:Dbox1:action:l4)
       ) 
     )

    ((= key "JB_1_to1");;;alle auswhlen
     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 $value "JB_1_to1"))
     (set_tile "JB_1_l1" "")
     (if (= $value "1")
       (progn
         (JB_LAF:Dbox1:action:b2:l1_sel)
         (if (<=(length l1&DBox1)256)
           (set_tile "JB_1_l1" (vl-string-right-trim " "(apply 'strcat(mapcar '(lambda(X)(strcat (itoa X)" "))l1_sel&Dbox1))))
           (set_tile "JB_1_l1" "")
           )
         )
       (progn
         (setq l1_sel&Dbox1 '(0))
         (set_tile "JB_1_l1" (vl-string-right-trim " "(apply 'strcat(mapcar '(lambda(X)(strcat (itoa X)" "))l1_sel&Dbox1)))))
       )
     (JB_LAF:Dbox1:mode)
     )
     
     
    ((= key "cancel");;;Abbruch
     (setq JB_LAF$DCL$_1_po (done_dialog 99))
     )
    )
  )


;;;DBox1: setten
(defun JB_LAF:Dbox1:set ( / X)

  (JBf_Dcl:AddList:New "JB_1_l1" (mapcar '(lambda(X)
                                            (strcat
                                              (cadr X)
                                              "\t"
                                              (car X)
                                              )
                                            )l1&Dbox1))  
  (JBf_Dcl:AddList:New "JB_1_l4" l4&Dbox1)
  
  (set_tile "JB_1_l4" "")
  
  (if l4_sel&Dbox1
    (set_tile "JB_1_l4" (itoa l4_sel&Dbox1)))

  (set_tile "JB_1_l1" "")
  (if (not(and(=(cdr(assoc "JB_1_to1" Settings&dbox1))"1")(not l1_sel&Dbox1)))
    (if l1_sel&Dbox1
      (set_tile "JB_1_l1" (vl-string-right-trim " "(apply 'strcat(mapcar '(lambda(X)(strcat (itoa X)" "))l1_sel&Dbox1)))
        )
      )
    )

    
  (mapcar '(lambda(X)(set_tile (strcat "JB_1_"(car X))(cadr X)))
    (list
      (list "t1" (cdr(assoc "JB_1_t1" Settings&dbox1)))      
      (list "r1" (if(=(cdr(assoc "JB_1_r1-r2" Settings&dbox1))0)"1" "0"))
      (list "r2" (if(=(cdr(assoc "JB_1_r1-r2" Settings&dbox1))1)"1" "0"))
      (list "to1" (cdr(assoc "JB_1_to1" Settings&dbox1)))
      )
    )
  )
;;;DBox1, moden
(defun JB_LAF:Dbox1:mode ( / )
  (if l1&Dbox1
    (progn
      (mode_tile "JB_1_b2" 0)
      (mode_tile "JB_1_b3" 0)
      (mode_tile "JB_1_to1" 0)
      )
     (progn
      (mode_tile "JB_1_b2" 1)
      (mode_tile "JB_1_b3" 1)
      (mode_tile "JB_1_to1" 1)
      )    )

  (if l4_sel&Dbox1
    (progn
      (mode_tile "JB_1_b4" 0)
      (mode_tile "JB_1_b5" 0))
    (progn
      (mode_tile "JB_1_b4" 1)
      (mode_tile "JB_1_b5" 1))
    )

  (if (and(= (cdr(assoc "JB_1_to1" Settings&dbox1))"1")(not l1_sel&Dbox1))
    (mode_tile "JB_1_l1" 1)
    (mode_tile "JB_1_l1" 0)
    )

  (if (and(= (cdr(assoc "JB_1_to1" Settings&dbox1))"0")(not l1_sel&Dbox1))
    (alert "Der Namefilter entspricht keinem in der Zeichnung vorhandenen Layernamen."))
  
  )



;;;DBox 2 - Wert eingeben
(defun JB_LAF:Dbox2 (wert&Dbox2 label&Dbox2 Function&Dbox2 / DCLID OK)
  
  (while (not (member ok '(1 99)))
    (setq DclId (JBf_Dcl:Load_dialog JB_LAF_$DCL$_File "JB_LAF_2" JB_LAF$DCL$_2_po))
    (set_tile "JB_2_e1" wert&Dbox2)
    (mode_tile "JB_2_e1" 2)
    (set_tile "JB_2" label&Dbox2)
    
    (mapcar '(lambda (A) (action_tile A (strcat "(JB_LAF:Dbox2:action \"" A "\")")))
            '("accept" "cancel"
             )
    )
    (setq ok (start_dialog))
    (unload_dialog DclId)

    (if Function&Dbox2
      (if (eval(car Function&Dbox2))
        (if (= 99 (JB_LAF:Dbox3 (cadr Function&Dbox2)))
          (setq ok -1)
          )
        )
      )
        
   
    
    )
  (if (= ok 1)
    wert&Dbox2)
  
  )


;;;DBox2 action
(defun JB_LAF:Dbox2:action (key / )
  (cond
    ((= key "cancel");;;Abbruch
     (setq JB_LAF$DCL$_2_po (done_dialog 99))
     )
    ((= key "accept");;;OK
     (setq wert&Dbox2 (get_tile "JB_2_e1"))
     (setq JB_LAF$DCL$_2_po (done_dialog 1))
     )
    )
  )



(defun JB_LAF:Dbox3 (frage&Dbox3 / DCLID OK)
  (setq DclId (JBf_Dcl:Load_dialog JB_LAF_$DCL$_File "JB_LAF_3" JB_LAF$DCL$_3_po))
  (set_tile "JB_jn" frage&Dbox3)
  ;;;Button-Action
  (action_tile "JB_nein" "(setq JB_LAF$DCL$_3_po (done_dialog 99))") ;Nein
  (action_tile "JB_ja" "(setq JB_LAF$DCL$_3_po (done_dialog 1))") ;Ja
  (setq ok (start_dialog))
  (unload_dialog DclId)
  ok)
                                   


   
;;;DCL-schreiben
(defun JB_LAF:dcl:Write ( / file)  
  (if (and (setq JB_LAF_$DCL$_File (vl-filename-mktemp (strcat "LAF.dcl")))
           (setq file (open JB_LAF_$DCL$_File "w"))
      )
    (progn
      (mapcar '(lambda (A)
                       (write-line A file)
               )
              (mapcar '(lambda (A)
                               (strcat "\n" A)
                       )
              (list
                "//Hauptdialog"
                "JB_LAF_1: dialog {label= \"Layer-Farben\";"
                ":row {"
                ":boxed_column {label = \"Layer-Farbliste\";"
                ":radio_row {label = \"Sortierung nach\";"                
                ":radio_button {key = \"JB_1_r1\"; label = \"Farbe\";}"
                ":radio_button {key = \"JB_1_r2\"; label = \"Layername\";}"
                "}"
                ":list_box {key = \"JB_1_l1\"; label = \"(Mehrfachauswahl mit STRG+UMSCHALT)\";width = 90;height = 25; multiple_select=true;tabs = \"35\";}"
                ":row {"
                ":toggle {key = \"JB_1_to1\"; label = \"alle auswhlen\";}"
                ":button {key = \"JB_1_b1\"; label = \"&Namefilter...\";}"
                ":text {key = \"JB_1_t1\";label = \"Layername\";width = 14;}"
                ":button {key = \"JB_1_b2\"; label = \"&Farbe ndern...\";}"
                "}"
                "}"
                ":boxed_column {label = \"Farbliste (Name ndern mit Doppelklick)\";"
                ":list_box {key = \"JB_1_l4\";width = 40;height = 28;}"
                ":row {"
                ":button {key = \"JB_1_b3\"; label = \"&Speichern...\";}"
                ":button {key = \"JB_1_b4\"; label = \"&Lschen\";}"
                ":button {key = \"JB_1_b5\"; label = \"&Wiederherstellen\";}"
                "}"
                "}"
                "}"
                ":row{fixed_width = true;alignment = centered;"
                ":retirement_button {label = \"&Ende\"; key= \"cancel\"; fixed_width = true;is_cancel=true;}"
                "}"
                "}"
                "JB_LAF_2: dialog {key = \"JB_2\";"
                ":boxed_column {key = \"Wert eingeben\";"
                ":edit_box {key = \"JB_2_e1\"; allow_accept=true;edit_width = 30;}"
                "}"
                "ok_cancel;}"
                "JB_LAF_3: dialog {label = \"Frage: Ja oder Nein\";"
                ":text {value = \"Hier kommt die zu bejahende oder beneinende Frage hin.\"; key =\"JB_jn\"; width = 100;}"
                ": row {fixed_width = true;alignment = centered;"
                ": retirement_button {label= \" Ja \"; key   = \"JB_ja\"; is_default  = true; }"
                ": spacer { width = 2;}"
                ": retirement_button {label = \"Nein\"; key = \"JB_nein\"; is_cancel= true;}}}"



               )
              )
      )
      (close file)
      JB_LAF_$DCL$_File
    )
  )
)
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine verwaltungstechnische Funktionen							   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Fehlermeldung
;;;Fehlermeldung;;;
(defun JBf_Error  (s)
  (print (strcat "***Fehler*** " s))
  (JBf_Reinit))

;;;Initialisierungsfunktion
(defun JBf_init (InitVaris / )
  (setq	JB_Error *error*
        *error* JBf_Error)
  (vl-load-com)
  ;;;Systemvariablen aktuelle Einstellungen fr ReInit speichern
  (setq JBf$ReInit$Varis
         (mapcar '(lambda(A)
                    (list (car A)(getvar (car A))))InitVaris))
  ;;;Vorgabeeistellungen fr Systemvariablen
  (mapcar '(lambda(A)
             (if (cadr A)
               (setvar (car A)(cadr A))))InitVaris)
  )

;;;Reinitialisierung
(defun JBf_Reinit ( / n)
  ;;;Systemvariablen ReInitialisieren
  (mapcar '(lambda(A)
             (setvar (car A)(cadr A)))JBf$ReInit$Varis)
  (setq JBf$ReInit$Varis nil)
  (princ)
)
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Strings								   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;benutzerspezifischer Pfad zum Speichern von Programmeinstellungen auf dem Benutzer von Windows
;;;bergeben wird der relative Pfad, der hinter den Windows-Pfad angehngt wird. Wenn die Verzeichnisse nicht vorhanden sind werden sie erstellt.
(defun JBf_String:Userpfad:WinUser (UserPfad / )
  
  (setq UserList (JBf_String:Delimiter->List UserPfad "\\"))
  (setq Pfad (strcat "c:\\Users\\"(getvar "LOGINNAME")"\\"))
        

  ;;;wenn UserPfad noch nicht vorhanden, dann erstellen
  (mapcar '(lambda(A)
             (setq Pfad (strcat Pfad A "\\"))
             (if (not (JBf_String:FilePath? Pfad))
               (vl-mkdir Pfad)))
    UserList)
  Pfad
  )
;;;String anhand Trennzeichen in Liste zurckgeben
(defun JBf_String:Delimiter->List (Str Delim / StrList)
  (setq Str (vl-string-left-trim Delim Str)
	Str (vl-string-right-trim Delim Str))
  (if (vl-string-search Delim Str)
    (progn
      (while (vl-string-search Delim Str)
        (setq StrList (cons (substr Str 1 (vl-string-search Delim Str))StrList)
	      Str (vl-string-left-trim Delim(substr Str(+(vl-string-search Delim Str)(+ (strlen Delim)1))))))
      (if (/= Str "")
        (setq StrList (cons Str StrList))))
    (setq StrList (cons Str StrList)))
  (reverse StrList))


;;;Dateipfad prfen
(defun JBf_String:FilePath? (Pfad / FSO TRUE-FALSE)
  (setq Pfad (if(vl-string-search "." Pfad)(car(fnsplitl  Pfad))Pfad))
  (if (setq FSO (vlax-create-object "Scripting.FilesystemObject"))
    (progn
      (if (vlax-method-applicable-p FSO 'FOLDEREXISTS)
        (setq TRUE-FALSE
               (=(vl-catch-all-apply
                   'vlax-invoke-method
                   (list FSO 'FOLDEREXISTS Pfad)):vlax-true))
        (vlax-release-object FSO))))
  TRUE-FALSE)
	  
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Listen								   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Es wird der GcN-Eintrag gesubst
(defun JBf_list:subst:gc (liste Wert GcN / )
  (subst (cons GcN Wert)(assoc GcN liste)liste))
         


;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine TrueColor-Funktionen 						       			   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Fr Dialogfenster den Farbnamen als String zurckgeben, dabei eine GcList (list(cons 62 1)(cons 420 nil)(cons 430 nil) bergeben
(defun JBf_TrueColor:GetString (gcList / GC420 GC430 GC62 VLALIST)
  (setq gc62 (cdr(assoc 62 gcList))
	gc420 (cdr(assoc 420 gcList))
	gc430 (cdr(assoc 430 gcList)))



  (cond (gc430
	  gc430)
       (gc420
	  (setq vlaList (JBf_TrueColor:gcList->vlaList gcList))
	(strcat "R="(itoa(cdr(assoc "Red" vlaList)))
		" G="(itoa(cdr(assoc "Green" vlaList)))
		" B="(itoa(cdr(assoc "Blue" vlaList)))))
	('T (JBf_TrueColor:GetString:ACI_ColorName (abs gc62)))))


(defun JBf_TrueColor:GetString:ACI_ColorName (ACI / )
  (cond ((= ACI 1)"Rot")
        ((= ACI 2)"Gelb")	
	((= ACI 3)"Grn")
	((= ACI 4)"Cyan")
	((= ACI 5)"Blau")
	((= ACI 6)"Magenta")
	((= ACI 7)"Wei")
	((= ACI 256)"VonLayer")
	((= ACI 0)"VonBlock")
	('T (itoa ACI))))

;;;Ini-VlaList
(defun JBf_TrueColor:vlaList:Ini ( / )
  '(("Blue" . nil)
    ("BookName" . nil)
    ("ColorIndex" . nil)
    ("ColorMethod" . nil)
    ("ColorName" . nil)
    ("EntityColor" . nil)
    ("Green" . nil)
    ("Red" . nil)))

          

;;;##### GcList -> vlaList
(defun JBf_TrueColor:gcList->vlaList (gcList / GC420 GC430 GC62 RETLIST RGB)
  (setq gc62 (cdr(assoc 62 gcList))
	gc420 (cdr(assoc 420 gcList))
	gc430 (cdr(assoc 430 gcList))
	RetList (JBf_TrueColor:vlaList:Ini))
		  
  (if (and gc430 (vl-string-search "$" gc430))
    (setq RetList (JBf_list:subst:gc RetList (substr gc430 1 (vl-string-search "$" gc430))"BookName")
	  RetList (JBf_list:subst:gc RetList (substr gc430 (+ 2(vl-string-search "$" gc430)))"ColorName")))

  (cond ((= gc62 0);;;ByBlock
	 (setq RetList(JBf_list:subst:gc RetList 193 "ColorMethod")
	       RetList(JBf_list:subst:gc RetList 0 "Red")
	       RetList(JBf_list:subst:gc RetList 0 "Green")
	       RetList(JBf_list:subst:gc RetList 0 "Blue")
	       RetList(JBf_list:subst:gc RetList 0 "ColorIndex")))

	((= gc62 256);;;ByLayer
	 (setq RetList(JBf_list:subst:gc RetList 192 "ColorMethod")
	       RetList(JBf_list:subst:gc RetList 0 "Red")
	       RetList(JBf_list:subst:gc RetList 0 "Green")
	       RetList(JBf_list:subst:gc RetList 0 "Blue")
	       RetList(JBf_list:subst:gc RetList 256 "ColorIndex")))

	('T ;;;ACI
	 (setq RetList(JBf_list:subst:gc RetList 195 "ColorMethod")
	       RGB(JBf_TrueColor:gcList->vlaList:aci->rgb gc62)
	       RetList(JBf_list:subst:gc RetList (car RGB) "Red")
	       RetList(JBf_list:subst:gc RetList (cadr RGB) "Green")
	       RetList(JBf_list:subst:gc RetList (caddr RGB) "Blue")
	       RetList(JBf_list:subst:gc RetList gc62 "ColorIndex"))
	 ))
  (setq RetList (JBf_list:subst:gc RetList (+ (lsh (boole 9 (cdr(assoc "ColorMethod" RetList)) 255) 24) (fix (cdr(assoc "ColorIndex" RetList))))"EntityColor"))

  (if gc420
    (setq RetList(JBf_list:subst:gc RetList 194 "ColorMethod")
	  RGB(JBf_TrueColor:gcList->vlaList:aci->rgb gc62)
	  RetList(JBf_list:subst:gc RetList (lsh (fix gc420) -16) "Red")
	  RetList(JBf_list:subst:gc RetList (lsh (lsh (fix gc420) 16) -24) "Green")
	  RetList(JBf_list:subst:gc RetList (lsh (lsh (fix gc420) 24) -24) "Blue")
	  RetList(JBf_list:subst:gc RetList (+ (lsh (boole 9 (cdr(assoc "ColorMethod" RetList)) 255) 24)
					       (lsh (fix (cdr(assoc "Red" RetList))) 16)
					       (lsh (fix (cdr(assoc "Green" RetList))) 8)
					       (fix (cdr(assoc "Blue" RetList)))) "EntityColor")))
  RetList)


;;;aci Farbnummer in RGB-Werte
(defun JBf_TrueColor:gcList->vlaList:aci->rgb  (n / l1 l3)
  (cond
    ((or (> n 255) (< n 1)) nil)
    ((> 7 n 0) (JBf_TrueColor:gcList->vlaList:aci->rgb (+ 10 (* 40 (1- n)))))
    ((> 250 n 9)
     (setq l1 '(0 1 2 3 4 4 4 4 4 4 4 4 4 3 2 1 0 0 0 0 0 0 0 0))
     (setq l3 '(1 0.8 0.6 0.5 0.3))
     (mapcar '(lambda (v w /)
		(fix (*	255
			(+ (* 0.25
			      (nth (rem (+ (1- (/ n 10)) v) 24) l1)
			      (nth (/ (rem n 10) 2) l3))
			   (* (rem n 2)
			      0.125
			      (nth (rem (+ (1- (/ n 10)) w) 24) l1)
			      (nth (/ (rem n 10) 2) l3))))))
	     '(8 0 16)
	     '(20 12 4)))
    (1
     (apply '(lambda (v w /) (list w w w))
	    (assoc n
		   '((7 255)
		     (8 128)
		     (9 192)
		     (250 51)
		     (251 91)
		     (252 132)
		     (253 173)
		     (254 214)
		     (255 255)))))))









;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Listen in SIC-Datei sichern  					   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Liste in LSP-Datei sichern
;;;Sichern von Einstellungen, Ausfhrung
;;;liste => DottetPairList, die es zu sichern gilt
;;;path => vollstndiger Dateipfad mit Dateiname
;;;AcadTrustCheck => 'T or NIL, es wird bei 'T ein temnporrer TrustedPath erstellt und danach auch gleich wieder gelscht
(defun JBf_SIC:sichern (liste FilePath AcadTrustCheck / FILESTREAM X)

  (setq FileStream (open FilePath "w"))
  (write-line "'(" FileStream)
  (mapcar '(lambda (X)
                   (JBf_SIC:sichern:prin1 X FileStream)
           )
          liste
  )
  (write-line ")" FileStream)
  (close FileStream)

  (if
    (if AcadTrustCheck
      (car (JBf_SIC:load:Catch FilePath nil))
      (vl-catch-all-error-p
        (vl-catch-all-apply 'JBf_SIC:load (list FilePath))
      )
    )


    (if (findfile (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
      (progn
        (alert (strcat "Die Sicherungsdatei \n\n"
                       FilePath
                       "\n\n ist fehlerhaft und wird automatisch durch die BAK-Datei\n\n"
                       (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                       "\n\nersetzt."
               )
        )
        (if (vl-file-delete FilePath)
          (vl-file-copy (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak") FilePath)
          (alert (strcat "Die Sicherungsdatei \n\n"
                         FilePath
                         "\n\n ist fehlerhaft und konnte nicht automatisch durch die BAK-Datei\n\n"
                         (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                         "\n\nersetzt werden. Bitte fhren Sie diesen Arbeitsgang manuell durch."
                 )
          )
        )
      )

      (alert (strcat "Die Sicherungsdatei \n\n"
                     FilePath
                     "\n\n ist fehlerhaft, bitte lschen Sie diese, anderfalls kann das Programm nicht mehr\n"
                     "ordnungsgem starten."
             )
      )
    )
    (if (findfile (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
      (if (vl-file-delete (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
        (vl-file-copy FilePath (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
        (alert (strcat "Fr die Sicherungsdatei \n\n"
                       FilePath
                       "\n\n konnte keine BAK-Datei erstellt werden. Bitte lschen Sie die vorh. BAK-Datei\n\n"
                       (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                       "\n\nmanuell."
               )
        )
      )
      (vl-file-copy FilePath (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
    )
  )
)
;;;Laden der Datei um zu prfen, ob diese korrekt ist!
  (defun JBf_SIC:load (FilePath /)
    (load FilePath)
  )
;;;Pfad muss existieren, Prfung in aufrufender Funktion und temporrem TrustPath
  (defun JBf_SIC:load:Catch (PathFile ErrMsg / ERROR RETVAL TRUTHPATHSET)
    (if (JBf_AcadSystem:TrustedPaths?)
      (progn
        (setq TruthPathSet 'T)
        (JBf_AcadSystem:TrustedPaths:Add (strcat (car (fnsplitl PathFile)) "..."))
      )
    )

    (setq error (vl-catch-all-error-p
                  (setq RetVal (vl-catch-all-apply 'JBf_SIC:load (list PathFile)))
                )
    )
    (if (and error ErrMsg)
      (alert ErrMsg)
    )

    (if TruthPathSet
      (JBf_AcadSystem:TrustedPaths:Delete (strcat (car (fnsplitl PathFile)) "..."))
    )
    (list error RetVal)
  )
;;;Iteratives lustiges Listenschreiben
  (defun JBf_SIC:sichern:prin1 (A FileStream / B)

    (cond  ;;;wenn einzelner Eintrag
                 ((atom A)
                        (write-line (vl-prin1-to-string A) FileStream)
                 )
      ((and (atom (car A)) (not (cdr A)))  ;;;GC ohne Wert
            (write-line (vl-prin1-to-string A) FileStream)
      )
      ((and (atom (car A)) (cdr A) (not (listp (cdr A))))  ;;;DottedPair
            (write-line (vl-prin1-to-string A) FileStream)
      )
      ((and (atom (car A)) (cdr A) (listp (cdr A)) (= (length (cdr A)) 1) (atom (car (cdr A))))  ;;;GC + Wert
            (write-line (strcat "(" (vl-prin1-to-string (car A))) FileStream)
            (mapcar '(lambda (B)
                             (JBf_SIC:sichern:prin1 B FileStream)
                     )
                    (cdr A)
            )
         (write-line ")" FileStream)
      )
      ((and (atom (car A)) (cdr A) (listp (cdr A)))  ;;;GC + Liste
            (write-line (strcat "(" (vl-prin1-to-string (car A))) FileStream)
            (mapcar '(lambda (B)
                             (JBf_SIC:sichern:prin1 B FileStream)
                     )
                    (cdr A)
            )
         (write-line ")" FileStream)
      )
      ( 'T
        (write-line "(" FileStream)
        (mapcar '(lambda (B)
                         (JBf_SIC:sichern:prin1 B FileStream)
                 )
                A
        )
         (write-line ")" FileStream)
      )
    )
  )             

;;;--------------------------------------------------------------------------------------------------------
;;;Setzen von "TrustedPaths's" sab ACAD  2014								   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Prfen, ob bereits TrustedPaths in der aktuelle Version verwendet werden knnen
(defun JBf_AcadSystem:TrustedPaths? ( / )
  (and (= "ACAD" (strcase (getvar "PROGRAM"))) (getvar "SECURELOAD"))
  )

;;;Pfadangaben immer mit BackSlashes, "\\..." hinten angestellt, damit alle untergeordneten Verzeichnisse bercksichtigt werden
(defun JBf_AcadSystem:TrustedPaths:Add (pfad / TRUSTEDPATHS)
  (setq TrustedPaths(if (getvar "TRUSTEDPATHS")(getvar "TRUSTEDPATHS")""))
  (if(not(member (strcase pfad)(mapcar 'strcase (JBfd_AcadSystem:TrustedPath:Split TrustedPaths))))
    (setvar "TRUSTEDPATHS"(strcat TrustedPaths ";" pfad)))
  )

;;;Pfad entfernen
(defun JBf_AcadSystem:TrustedPaths:Delete (pfad / A TRUSTEDPATHS)
  (setq TrustedPaths(if (getvar "TRUSTEDPATHS")(getvar "TRUSTEDPATHS")""))
  (setvar "TRUSTEDPATHS"
	  (vl-string-right-trim ";"(apply 'strcat(mapcar '(lambda(A)
							   (strcat A ";"))
							(vl-remove-if 'not (mapcar '(lambda(A)
										      (if(/= (strcase pfad)(strcase A))A))
										   (JBfd_AcadSystem:TrustedPath:Split TrustedPaths)))))))
  )

;;;String splitten an Semikolons, als Liste zurckgeben
(defun JBfd_AcadSystem:TrustedPath:Split (TrustedPaths / A RETLIST TEMP)
  (mapcar '(lambda(A)
	     (if (/= A 59)
	       (setq temp (cons A temp))
	       (setq RetList (cons (vl-list->string(reverse temp))RetList)
		     temp nil))
	     )
	     (vl-string->list TrustedPaths))
  (if temp
    (setq RetList (cons (vl-list->string (reverse temp))RetList)))
  (reverse RetList))
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Dcl									   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;DCL-Dialogfenster laden
(defun JBf_Dcl:Load_dialog (FileName DialogName JB_$DCL$_x_po / DclId)
  (setq DclId (load_dialog FileName))
  (if	JB_$DCL$_x_po
    (if (not (new_dialog DialogName DclId "" JB_$DCL$_x_po))
      (exit))
    (if (not (new_dialog DialogName DclId))
      (exit)))
  DclId
  )

;;;DCL-Liste komplett neu fllen
(defun JBf_Dcl:AddList:New (key liste / )
  (start_list key 3)
  (mapcar 'add_list liste)
  (end_list)
  )

;;;--------------------------------------------------------------------------------------------------------
;;;Info fr Textfenster nach dem laden des Programms							   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(princ (strcat
          "\n|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++|"
          "\n|Layer-Farben: speichern und wiederherstellen.               |"
          "\n|------------------------------------------------------------|"
          "\n|erstellt durch Bosse-engineering - www.bosse-engineering.com|"
          "\n|------------------------------------------------------------|"
          "\n|Befehlszeilenaufruf: LAF                                    |"          
          "\n|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++|"
          )
       )
(princ)








         

          
          





  










